<?php

/**
 * i-doit
 *
 * @package     Modules
 * @subpackage  API
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_auth_api extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var isys_auth_analytics
     */
    private static $instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     */
    public function get_auth_methods()
    {
        return [
            'configuration'         => [
                'title'  => 'LC__ADDON__API__AUTH_CONFIGURATION',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EDIT
                ]
            ],
            'categories_attributes' => [
                'title'  => 'LC__ADDON__API__AUTH_CATEGORIES_ATTRIBUTES',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW
                ]
            ],
        ];
    }

    /**
     * Get ID of related module
     *
     * @return int
     */
    public function get_module_id()
    {
        return C__MODULE__API;
    }

    /**
     * Get title of related module
     *
     * @return string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__API';
    }

    /**
     * Retrieve singleton instance of authorization class
     *
     * @return isys_auth_analytics
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self;
        }

        return self::$instance;
    }
}
