<?php

use idoit\Component\Property\PropertyConfiguration;

/**
 * i-doit
 *
 * API model
 *
 * @package    i-doit
 * @subpackage API
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_cmdb_category_info extends isys_api_model_cmdb_category
{
    /**
     * Data formatting used in format methods
     *
     * @var array
     */
    protected $m_mapping = [];

    /**
     * Possible options and their parameters
     *
     * @var array
     */
    protected $m_options = [
        'read' => []
    ];

    /**
     * Validation
     *
     * @var array
     */
    protected $m_validation = [];

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @internal param string $p_method Data method
     * @return isys_api_model_cmdb Returns itself.
     */
    public function create($p_params)
    {
        return null;
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @internal param string $p_method Data method
     * @return isys_api_model_cmdb Returns itself.
     */
    public function delete($p_params)
    {
        return null;
    }

    /**
     * Get category info
     *
     * @param array $p_params
     *
     * @throws isys_exception_api
     * @return array
     */
    public function read($p_params)
    {
        $l_return = [];

        if (($l_cat = $this->prepare($p_params))) {
            if (!method_exists($l_cat, 'get_properties')) {
                throw new isys_exception_api('get_properties method does not exist for ' . get_class($l_cat), -32601);
            }

            $l_properties = [];
            $l_properties_tmp = $l_cat->get_properties();

            foreach ($l_properties_tmp as $l_propkey => $l_propdata) {
                $l_properties[$l_propkey] = [
                    'title'            => _L(@$l_propdata[C__PROPERTY__INFO]['title']),
                    C__PROPERTY__CHECK => [
                        C__PROPERTY__CHECK__MANDATORY => $l_propdata[C__PROPERTY__CHECK][C__PROPERTY__CHECK__MANDATORY]
                    ]
                ];

                $propertyParts = [C__PROPERTY__INFO, C__PROPERTY__DATA, C__PROPERTY__UI, C__PROPERTY__FORMAT];

                foreach ($propertyParts as $propertyPart) {
                    if (is_array($l_propdata[$propertyPart])) {
                        $l_properties[$l_propkey][$propertyPart] = $l_propdata[$propertyPart];
                    } elseif (is_object($l_propdata[$propertyPart]) && $l_propdata[$propertyPart] instanceof PropertyConfiguration) {
                        /** @var PropertyConfiguration $l_propdata [$propertyPart] */
                        $l_properties[$l_propkey][$propertyPart] = $l_propdata[$propertyPart]->toArray();
                    } elseif (\is_object($l_propdata[$propertyPart])) {
                        $l_properties[$l_propkey][$propertyPart] = (array)$l_propdata[$propertyPart];

                        // This is necessary since the keys will contain null-byte characters.
                        foreach ($l_properties[$l_propkey][$propertyPart] as $key => $value) {
                            if ($value === null) {
                                unset($l_properties[$l_propkey][$propertyPart][$key]);
                                continue;
                            }

                            if (is_array($value) && empty($value)) {
                                unset($l_properties[$l_propkey][$propertyPart][$key]);
                                continue;
                            }

                            $newKey = str_replace("\0*\0", '', $key);

                            if ($newKey === $key) {
                                continue;
                            }

                            $l_properties[$l_propkey][$propertyPart][$newKey] = $value;
                            unset($l_properties[$l_propkey][$propertyPart][$key]);
                        }
                    }
                }
            }

            return $l_properties;
        }

        return $l_return;
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return void
     */
    public function update($p_params)
    {
        return null;
    }
}
