<?php

namespace idoit\Module\Api\Controller;

use Exception;
use idoit\Module\Api\Category\Descriptor;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Throwable;

/**
 * i-doit AttributeDocumentation controller.
 *
 * @package   api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class AttributeDocumentationController
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws Exception
     */
    public function getCategoryDefinition(Request $request): JsonResponse
    {
        try {
            return new JsonResponse([
                'success' => true,
                'data'    => Descriptor::byId($request->query->get('categoryType'), (int)$request->query->get('categoryId'))->getDefinition(),
                'message' => ''
            ]);
        } catch (Throwable $e) {
            return new JsonResponse([
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ]);
        }
    }
}
