<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\CmdbObject;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Endpoint\Validate;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use isys_auth;
use isys_module_cmdb;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object purge endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Purge extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.purge.v2', 'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_PURGE', [
            new RequiredParameter('object', Parameter::TYPE_INTEGER, 'LC__ADDON__API__PARAMETER__OBJECT_ID', [Validate::class, 'isId']),
        ]);
    }

    public function request(Request $request): JsonRpcResponse
    {
        $objectId = $request->request->get('object');

        $object = new CmdbObject($objectId);

        isys_module_cmdb::getAuth()->obj_id(isys_auth::SUPERVISOR, $objectId);

        // @see API-191 Check and react to the object lock.
        $this->lockObject($objectId);

        if (!$object->purge()) {
            throw new InternalErrorException('Unable to purge object.');
        }

        // @see API-191 Unlock the object once the request has finished.
        $this->unlockObject($objectId);

        return new JsonRpcResponse([
            'success' => true,
            'message' => "Object {$objectId} has been purged."
        ]);
    }
}
