<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\ObjectTypeGroup;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\Helper;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use isys_auth;
use isys_module_system;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object type group create endpoint (v2).
 *
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Create extends AbstractObjectTypeGroupEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition(
            'cmdb.object-type-group.create.v2',
            'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_TYPE_GROUP_CREATE',
            [
                new RequiredParameter('title', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__CMDB_OBJECT_TYPE_GROUP_TITLE', fn ($title) => trim($title) !== ''),
                new OptionalParameter('sort', Parameter::TYPE_INTEGER, 'LC__ADDON__API__PARAMETER__CMDB_OBJECT_TYPE_GROUP_SORT'),
                new OptionalParameter('visible', Parameter::TYPE_BOOLEAN, 'LC__ADDON__API__PARAMETER__CMDB_OBJECT_TYPE_GROUP_VISIBLE')
            ],
            [
                'Basic request' => Helper::exampleRequest('cmdb.object-type-group.create.v2', [
                    'title' => 'Example group',
                    'visible' => true,
                    'sort' => 10,
                ])
            ],
            ['Basic response' => Helper::exampleResponse(['success' => true, 'id' => 123])]
        );
    }

    /**
     * @param Request $request
     *
     * @return JsonRpcResponse
     * @throws InternalErrorException
     * @throws \isys_exception_dao
     */
    public function request(Request $request): JsonRpcResponse
    {
        isys_module_system::getAuth()->check(isys_auth::EXECUTE, 'globalsettings/qcw');

        $data = [
            'title'   => $request->request->get('title'),
            'sort'    => $request->request->get('sort'),
            'visible' => $request->request->get('visible'),
        ];

        if ($this->write(null, $data)) {
            return new JsonRpcResponse([
                'success' => true,
                'id' => (int) $this->daoCmdb->get_last_id_from_table('isys_obj_type_group')
            ]);
        }

        return new JsonRpcResponse(['success' => false]);
    }
}
