<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.10.2
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * IpProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class PersonGroupMembersProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // Get request
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (is_array($request) && $request['option'] === 'read' && is_array($response) && count($response) > 0) {
            $cmdbDao = \isys_application::instance()->container->get('cmdb_dao');
            $language = \isys_application::instance()->container->get('language');

            // Here we set the correct "id" so that the users will know which ID to purge.
            foreach ($response as &$responseItem) {
                $sql = 'SELECT isys_person_2_group__id AS id, isys_contact_tag__id AS roleId, isys_contact_tag__title AS roleTitle, isys_contact_tag__const AS roleConst
                    FROM isys_person_2_group
                    LEFT JOIN isys_contact_tag ON isys_contact_tag__id = isys_person_2_group__isys_contact_tag__id
                    WHERE isys_person_2_group__isys_obj__id__person = ' . $cmdbDao->convert_sql_id($responseItem['connected_object']['id']) . '
                    AND isys_person_2_group__isys_obj__id__group = ' . $cmdbDao->convert_sql_id($responseItem['objID']) . '
                    LIMIT 1;';

                $row = $cmdbDao->retrieve($sql)->get_row();

                $responseItem['id'] = (int)$row['id'];
                $responseItem['role'] = null;

                // @see API-345
                if (!empty($row['roleId'])) {
                    $responseItem['role'] = [
                        'id' => (int)$row['roleId'],
                        'title' => $row['roleTitle'],
                        'const' => $row['roleConst'],
                        'title_lang' => $language->get($row['roleTitle'])
                    ];
                }
            }
        }

        return array_values($response);
    }
}
