<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class ObjectBrowser
 *
 * @package idoit\Module\Api\Validation\Property
 */
class ObjectBrowser extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->value;

        // Check whether object browser supports multiselection or not
        if ($this->propertyDefinition[C__PROPERTY__DATA][C__PROPERTY__DATA__TYPE] === C__TYPE__INT
            && !$this->propertyDefinition[C__PROPERTY__UI][C__PROPERTY__UI__PARAMS]['multiselection']) {
            if (!is_int($value)) {
                throw new ValidationException($this->getPropertyType(), 'Property has to be an integer value.');
            }
        } else {
            if (!is_array($value)) {
                throw new ValidationException($this->getPropertyType(), 'Property has to be an array.');
            }
        }

        // Arrayize object ids
        $objectIds = is_array($value) ? $value : [$value];

        if (count(array_filter($objectIds, function ($objectId) {
            return !is_int($objectId) || $objectId <= 0;
        }))) {
            throw new ValidationException($this->getPropertyType(), 'Please provide only positive integer numbers.');
        }

        // Check whether object browser is referencing objects and not something other like License keys, Ports, etc...
        if (empty($this->propertyDefinition[C__PROPERTY__UI][C__PROPERTY__UI__PARAMS]['secondSelection'])) {
            // Calculate number of non existing objects
            $notExistingObjects = array_filter($objectIds, function ($objectId) {
                return !\isys_cmdb_dao::instance(\isys_application::instance()->container->get('database'))
                    ->obj_exists($objectId);
            });

            // Check whether there are non existing objects
            if (count($notExistingObjects)) {
                throw new ValidationException($this->getPropertyType(), 'Provided object(s) \'' . implode(',', $notExistingObjects) . '\' not exists');
            }
        } else {
            /**
             * @todo Can we guarantee proper validation of data
             *       which is referencing something other than objects
             */
        }

        return true;
    }
}
