<?php

use idoit\Module\Api\Model\Cabling\CablingProvider;

class isys_api_model_cmdb_cabling extends isys_api_model_cmdb implements isys_api_model_interface
{
    /**
     * Possible options and their parameters
     *
     * @var array
     */
    protected $m_options = [
        'read' => [
            'objID' => [
                'type'        => 'int',
                'description' => 'Object id',
                'optional'    => false,
            ]
        ]
    ];

    /**
     * Validation.
     *
     * @var  array
     */
    protected $m_validation = [
        'read' => ['objID']
    ];

    /**
     * @param $parameters
     *
     * @return array
     * @throws isys_exception_database
     */
    public function read($parameters)
    {
        return CablingProvider::instance()->getConnections($parameters['objID']);
    }
}
