<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Exception\JsonRpc;

use Throwable;

/**
 * Class AbstractJsonRpcException
 *
 * @package idoit\Module\Api\Exception\JsonRpc
 */
abstract class AbstractJsonRpcException extends \Exception
{
    /** @deprecated Use 'ParseException::CODE' */
    const PARSE = ParseException::CODE;

    /** @deprecated Use 'RequestException::CODE' */
    const INVALID_REQUEST = RequestException::CODE;

    /** @deprecated Use 'MethodException::CODE' */
    const METHOD_NOT_FOUND = MethodException::CODE;

    /** @deprecated Use 'ParameterException::CODE' */
    const INVALID_PARAMS = ParameterException::CODE;

    /** @deprecated Use 'InternalErrorException::CODE' */
    const INTERNAL_ERROR = InternalErrorException::CODE;

    /** @deprecated Use 'SystemException::CODE' */
    const SYSTEM_ERROR = SystemException::CODE;

    /**
     * Exception Register
     *
     * @var array
     */
    public static $register = [
        ParseException::CODE         => ParseException::class,
        RequestException::CODE       => RequestException::class,
        MethodException::CODE        => MethodException::class,
        ParameterException::CODE     => ParameterException::class,
        InternalErrorException::CODE => InternalErrorException::class,
        SystemException::CODE        => SystemException::class,
    ];

    /**
     * Get Exception by code
     *
     * @param $errorCode
     *
     * @return string
     */
    public static function getExceptionByCode($errorCode)
    {
        if (!isset(self::$register[$errorCode])) {
            return SystemException::class;
        }

        return self::$register[$errorCode];
    }

    /**
     * Error related data
     *
     * @var array
     */
    protected $data = null;

    /**
     * Get error code
     *
     * @return int
     */
    public abstract function getErrorCode(): int;

    /**
     * Get error topic
     *
     * @return string
     */
    public abstract function getErrorTopic(): string;

    /**
     * Get data
     *
     * @return array
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set data
     *
     * @param array $data
     *
     * @return AbstractJsonRpcException
     */
    public function setData(array $data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * AbstractJsonRpcException constructor.
     *
     * @param string          $message
     * @param int             $code
     * @param Throwable|null $previous
     */
    public function __construct(string $message = "", int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }
}
