<?php

namespace idoit\Module\Api\Model\External;

use ArrayIterator;
use idoit\Module\Api\Model\External\Push\Category;

abstract class AbstractExternal
{
    /**
     * @var Config
     */
    protected Config $config;

    /**
     * @var Category[]
     */
    protected array $data = [];

    /**
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @return Config
     */
    public function getConfig(): Config
    {
        return $this->config;
    }

    /**
     * @return Category[]
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @param array $data
     */
    protected function setData(array $data): void
    {
        $this->data = $data;
    }
}