<?php

namespace idoit\Module\Api\PushIdentifier\SyncNormalizer\DataShapes;

use idoit\Module\Api\Model\External\Config;
use idoit\Module\Api\Model\External\Handler\Category;
use idoit\Module\Api\Model\External\Push;
use idoit\Module\Api\PushIdentifier\PushIdentifier;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataNormalizer\ObjectBrowser\SingleSecondSelectBrowser;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataNormalizer\ObjectBrowser\SingleSelectBrowser;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataNormalizerProviderConfig;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataShapes\AbstractBrowserShape;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataShapes\ShapeInterface;
use idoit\Module\Cmdb\Component\SyncNormalizer\DataShapes\StringShape;
use isys_application;

class PushEntryShape extends AbstractBrowserShape implements ShapeInterface
{
    const KEYS = [
        'category',
        'value',
        'object',
    ];

    /**
     * @param DataNormalizerProviderConfig $config
     * @param string                       $propertyKey
     * @param array                        $requestData
     *
     * @return mixed|void
     * @throws \isys_exception_validation
     */
    public function handle(DataNormalizerProviderConfig $config, string $propertyKey, array $requestData)
    {
        $pushData = $this->value['object'];
        $pushConfig = new Config($pushData['extType'], $pushData['extId'], $pushData['title'], $pushData['class'], $pushData['data']);

        if ((new Push($pushConfig))->prepare()->sync()) {
            $extId = $this->value['value'];
            $category = $this->value['category'];
            $pushIdent = PushIdentifier::instance(isys_application::instance()->container->get('database'));
            $data = $pushIdent->findReferences("{$pushData['extType']}/{$pushData['extId']}/{$category}", $extId);

            if (is_array($data) && count($data) === 1) {
                $this->setValue((int) $data[0]['referenceId']);
            }
        }
    }

    /**
     * @param $value
     *
     * @return bool
     */
    public function isApplicable($value): bool
    {
        if (parent::isApplicable($value) && is_array($value['object'])) {

            $subkeys = PushIdentifierShape::KEYS;
            $subKeys[] = 'data';

            $keys = array_keys($value['object']);
            $filteredKeys = array_filter($keys, fn ($item) => in_array($item, $subKeys));

            return count($filteredKeys) >= count($subKeys)
                && isset($value['object']['data'])
                && !empty($value['object']['data']);
        }
        return false;
    }
}
