<?php

namespace idoit\Module\Api\SettingPage;

use idoit\Module\System\SettingPage\SettingPage;
use isys_application;
use isys_auth;
use isys_cmdb_dao_category;
use isys_module_api;

/**
 * Class CustomTranslation
 *
 * @package idoit\Module\System\SettingPage
 */
class AttributeDocumentation extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return void
     * @throws \isys_exception_auth
     */
    public function renderPage($navMode)
    {
        // Check right system.
        isys_module_api::getAuth()->check(isys_auth::VIEW, 'CATEGORIES_ATTRIBUTES');

        $rules = [
            'C__API__CATEGORY_SELECTION' => [
                'chosen' => true,
                'p_arData' => $this->getCategories()
            ]
        ];

        $this->tpl
            ->activate_editmode()
            ->assign('content_title', $this->lang->get('LC__ADDON__API__ATTRIBUTE_DOCUMENTATION'))
            ->smarty_tom_add_rules('tom.content.bottom.content', $rules)
            ->include_template('contentbottomcontent', isys_module_api::getPath() . '/templates/attribute-configuration.tpl');
    }

    /**
     * @return array
     * @throws \Exception
     * @see API-504
     */
    private function getCategories(): array
    {
        $categoryStore = [];
        $cmdbDao = isys_application::instance()->container->get('cmdb_dao');

        $categoryTypeAbbrTitles = [
            'g' => $this->lang->get('LC__CMDB__GLOBAL_CATEGORIES'),
            's' => $this->lang->get('LC__CMDB__SPECIFIC_CATEGORIES'),
            'g_custom' => $this->lang->get('LC__CMDB__CUSTOM_CATEGORIES'),
        ];

        foreach (['g', 's', 'g_custom'] as $categoryTypeAbbr) {
            $categoryResource = $cmdbDao->get_isysgui("isysgui_cat{$categoryTypeAbbr}");

            // @see ID-8942 Initialize the category type.
            $categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]] = [];

            while ($categoryRow = $categoryResource->get_row()) {
                $parentTitle = '';
                $idField = "isysgui_cat{$categoryTypeAbbr}__id";
                $titleField = "isysgui_cat{$categoryTypeAbbr}__title";
                $parentField = "isysgui_cat{$categoryTypeAbbr}__parent";
                $typeField = "isysgui_cat{$categoryTypeAbbr}__type";

                // @see API-309 Skip 'view' categories
                if ($categoryRow[$typeField] == isys_cmdb_dao_category::TYPE_VIEW) {
                    continue;
                }

                // @see  API-196 ID-7042  Categories with "parents" need to display their names in order to make sense.
                if (isset($categoryRow[$parentField]) && $categoryRow[$parentField]) {
                    if ($categoryTypeAbbr === 'g') {
                        $parentTitle = $this->lang->get($cmdbDao->get_catg_name_by_id_as_string($categoryRow[$parentField])) . ' > ';
                    } elseif ($categoryTypeAbbr === 's') {
                        // @see API-338 Use a different method to get 'parent' categories.
                        $parents = [];
                        $parentResult = $cmdbDao->cats_get_parent_cats($categoryRow[$idField], true);

                        while ($parentRow = $parentResult->get_row()) {
                            $parents[] = $this->lang->get($parentRow['isysgui_cats__title']);
                        }

                        if (count($parents)) {
                            $parentTitle = implode(' / ', $parents) . ' > ';
                        }
                    }
                }

                $key = $categoryTypeAbbr . '.' . $categoryRow[$idField];
                $value = $parentTitle . $this->lang->get($categoryRow[$titleField]);

                $categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]][$key] = $value;
            }

            uasort($categoryStore[$categoryTypeAbbrTitles[$categoryTypeAbbr]], 'strnatcasecmp');
        }

        return $categoryStore;
    }
}
