<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class Text
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Text extends PropertyValidation
{

    /*
     * List of properties allowed for length over getMaximumLength
     * */
    private $allowedLongtextProperties = array(
        'file_content',
    );

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();

        // @see API-289
        if (strlen($value) === 0) {
            return true;
        }

        if (!is_string($value)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be a string value.');
        }

        if ((isys_strlen($value) > $this->getMaximumLength())&&(!in_array($this->getTitle(), $this->allowedLongtextProperties))) {
            throw new ValidationException($this->getPropertyType(), 'Property exceeded maximum length of possible ' . $this->getMaximumLength() . ' characters.');
        }

        return true;
    }

    /**
     * Get maximum string length
     *
     * @return int
     */
    public function getMaximumLength()
    {
        return 255;
    }
}
