<table class="contentTable">
    <tr>
        <td class="key">[{isys type="f_label" name="C__API__CATEGORY_SELECTION" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__PLEASE_SELECT_A_CATEGORY"}]</td>
        <td class="value">[{isys type="f_dialog" name="C__API__CATEGORY_SELECTION"}]</td>
    </tr>
</table>

<div class="hide" id="apiAttributeDocumentation">
    <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CATEGORY_INFORMATION"}]</h3>

    <table class="contentTable">
        <tr>
            <td class="key">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ID"}]</td>
            <td class="value pl20" id="apiCategoryId"></td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__CONSTANT"}]</td>
            <td class="value pl20" id="apiCategoryConstant"></td>
        </tr>
        <tr>
            <td class="key">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__MULTIVALUE"}]</td>
            <td class="value pl20" id="apiCategoryMultivalue"></td>
        </tr>
    </table>

    <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES"}]</h3>

    <div class="display-flex apiConfigurationContainer">
        <div class="attribute-list-container">
            <table class="listing border">
                <thead>
                <tr>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TITLE"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__KEY"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_READ"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DATA_TYPE_WRITE"}]</th>
                </tr>
                </thead>
                <tbody id="apiPropertyTable">
                    <!-- To be filled by JS -->
                </tbody>
            </table>
        </div>

        <div id="apiPropertyDefinition" class="attribute-definition-container">
            <h2 class="mt20 mb10" id="apiPropertyType"></h2>

            <table class="listing border write">
                <thead>
                <tr>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DESCRIPTION"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLE"}]</th>
                </tr>
                </thead>
                <tbody id="apiPropertyWriteDefinitionTable">
                    <!-- To be filled by JS -->
                </tbody>
            </table>

            <table class="listing read">
                <tbody id="apiPropertyReadType">
                    <!-- To be filled by JS -->
                </tbody>
            </table>

            <h2 class="mt20 mb10 read" id="apiPropertyType">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__DEFINITION"}]</h2>

            <table class="listing border read">
                <thead>
                <tr>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__KEY"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE"}]</th>
                    <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__DESCRIPTION"}]</th>
                </tr>
                </thead>
                <tbody id="apiComplexDefinitionTable">
                    <!-- To be filled by JS -->
                </tbody>
            </table>

            <table class="listing read">
                <tbody>
                    <tr>
                        <td id="apiSimpleDefinitionTable"></td>
                    </tr>
                </tbody>
            </table>

            <h2 class="mt20 mb10">[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__EXAMPLE"}]</h2>

            <pre class="border border-neutral-400 bg-neutral-200 m10" id="apiPropertyExample"></pre>
        </div>
    </div>
</div>

<style>
    .apiConfigurationContainer pre {
        padding: 10px;
        white-space: pre-wrap;
    }

    .apiConfigurationContainer .attribute-list-container {
        width: 70%;
        min-width: 70%;
        max-width: 70%;
        padding: 10px;
    }

    .apiConfigurationContainer .attribute-definition-container {
        width: 30%;
        min-width: 30%;
        max-width: 30%;
        padding: 10px;
    }

    .apiConfigurationContainer .entityDescriptor {
        cursor: pointer;
        text-decoration: underline dotted;
    }
</style>

<script>
    (function () {
        const $categorySelection = $('C__API__CATEGORY_SELECTION');
        const $apiAttributeDocumentation = $('apiAttributeDocumentation');

        const $apiPropertyTable = $('apiPropertyTable');
        const $apiPropertyDefinition = $('apiPropertyDefinition');

        $categorySelection.on('change', () => {
            const selectedCat = $categorySelection.getValue().split('.');

            $apiAttributeDocumentation.addClassName('hide');

            if (selectedCat <= 0) {
                return;
            }

            new Ajax.Request(idoit.Router.getRoute('api.get-category-definition'), {
                method:     'get',
                parameters: {
                    categoryType: selectedCat[0],
                    categoryId: selectedCat[1]
                },
                onComplete:  function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    $apiAttributeDocumentation.removeClassName('hide');
                    $apiPropertyDefinition.addClassName('hide');

                    const json = xhr.responseJSON;

                    $('apiCategoryId').update(json.data.id)
                    $('apiCategoryConstant').update(json.data.constant)
                    $('apiCategoryMultivalue').update(json.data.multiValue
                        ? '[{isys type="lang" ident="LC__UNIVERSAL__YES"}]'
                        : '[{isys type="lang" ident="LC__UNIVERSAL__NO"}]')

                    $apiPropertyTable.update();

                    for (let i in json.data.properties) {
                        if (!json.data.properties.hasOwnProperty(i)) {
                            continue;
                        }

                        const prop = json.data.properties[i];
                        const $row = new Element('tr')
                            .update(new Element('td').update(prop.title))
                            .insert(new Element('td').update(prop.key))
                            .insert(new Element('td').update(prop.propertyType))
                            .insert(new Element('td').update(new Element('span', { className: 'entityDescriptor', 'data-type': 'read', 'data-definition': JSON.stringify(prop.readEntity) }).update(prop.readEntity.type)))
                            .insert(new Element('td').update(new Element('span', { className: 'entityDescriptor', 'data-type': 'write', 'data-definition': JSON.stringify(prop.writeEntity) }).update(prop.writeEntity.definitions && prop.writeEntity.definitions.map((d) => d.type).join(' | '))));

                        $apiPropertyTable.insert($row);
                    }
                }
            });
        });

        $apiPropertyTable.on('click', '.entityDescriptor', (ev) => {
            const $trigger = ev.findElement('span');
            const definition = JSON.parse($trigger.readAttribute('data-definition'));

            $('apiPropertyType').update(definition.title);
            $('apiPropertyExample').update(JSON.stringify(definition.example, null, 2));

            if ($trigger.readAttribute('data-type') === 'read') {
                renderReadDefinition(definition);
            } else {
                renderWriteDefinition(definition);
            }
        });

        const renderReadDefinition = (definition) => {
            const isDefinitionObject = typeof definition.definition === 'object' && !Array.isArray(definition.definition) && definition.definition !== null
            const $simpleDefinitionTable = $('apiSimpleDefinitionTable').update('');
            const $complexDefinitionTable = $('apiComplexDefinitionTable').update('');

            $('apiPropertyReadType')
                .update(new Element('tr')
                    .update(new Element('td').update('[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__ATTRIBUTES__TYPE"}]'))
                    .insert(new Element('td').update(definition.type)));

            if (isDefinitionObject) {
                for (let i in definition.definition) {
                    if (!definition.definition.hasOwnProperty(i)) {
                        continue;
                    }

                    // Extract description
                    const description = definition.definition[i].replace(/^\([a-z\|]*\)/g, '');

                    // Extract type
                    let type = /^\([a-z\|]*\)/.exec(definition.definition[i]);

                    if (type && type.length) {
                        type = type[0].replace(/[\(\)]/g, '')
                    }

                    $complexDefinitionTable.insert(new Element('tr')
                        .update(new Element('td').update(i))
                        .insert(new Element('td').update(type))
                        .insert(new Element('td').update(description)));
                }
            } else {
                $simpleDefinitionTable.update(definition.definition);
            }

            $apiPropertyDefinition.removeClassName('hide');
            $apiPropertyDefinition.select('.read').invoke('removeClassName', 'hide');
            $apiPropertyDefinition.select('.write').invoke('addClassName', 'hide');

            if (isDefinitionObject) {
                $simpleDefinitionTable.up('table').addClassName('hide');
            } else {
                $complexDefinitionTable.up('table').addClassName('hide');
            }
        };

        const renderWriteDefinition = (definition) => {
            const $apiPropertyWriteDefinitionTable = $('apiPropertyWriteDefinitionTable').update('');

            for (let i in definition.definitions) {
                if (!definition.definitions.hasOwnProperty(i)) {
                    continue;
                }

                $apiPropertyWriteDefinitionTable.insert(new Element('tr')
                    .update(new Element('td').update(definition.definitions[i].type))
                    .insert(new Element('td').update(definition.definitions[i].description))
                    .insert(new Element('td').update(definition.definitions[i].example)));
            }

            $apiPropertyDefinition.removeClassName('hide');
            $apiPropertyDefinition.select('.read').invoke('addClassName', 'hide');
            $apiPropertyDefinition.select('.write').invoke('removeClassName', 'hide');
        };
    })();
</script>
