<?php

/**
 * i-doit
 *
 * API model
 *
 * @package    i-doit
 * @subpackage API
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_cmdb_location_tree extends isys_api_model_cmdb implements isys_api_model_interface
{
    /**
     * Data formatting used in format methods
     *
     * @var array
     */
    protected $m_mapping = [
        'isys_obj__id'                   => 'id',
        'isys_obj__title'                => 'title',
        'isys_obj__sysid'                => 'sysid',
        'isys_obj__isys_obj_type__id'    => 'type',
        'isys_obj_type__title'           => ['_L', 'type_title'],
        'isys_obj__status'               => 'status',
        'isys_obj__isys_cmdb_status__id' => 'cmdb_status',
        'isys_cmdb_status__title'        => ['_L', 'cmdb_status_title']
    ];

    /**
     * Possible options and their parameters
     *
     * @var array
     */
    protected $m_options = [
        'read' => []
    ];

    /**
     * Validation
     *
     * @var array
     */
    protected $m_validation = [];

    /**
     * Documentation missing
     *
     * @param array $p_params
     *
     * @return array
     */
    public function read($p_params)
    {
        $l_id = null;
        $l_raw = false;

        // Raw mode:
        if (isset($p_params['raw']))
        {
            $l_raw = (bool) $p_params['raw'];
        }

        // Location identifier:
        if (isset($p_params['id']) && $p_params['id'] > 0)
        {
            $l_id = $p_params['id'];
        }

        // Validate status filter value
        $this->validateStatus($p_params['status']);

        if ($this->useAuth)
        {
            isys_auth_cmdb_categories::instance()->check_rights_obj_and_category(isys_auth::VIEW, $l_id, 'C__CATG__LOCATION');
        }

        // Data retrieval:
        $l_loc_dao = new isys_cmdb_dao_location($this->m_db);
        $l_data    = $l_loc_dao->get_child_locations($l_id, false, false, false, $p_params['status']);

        $l_return = [];

        // Data formatting:
        while ($l_row = $l_data->get_row())
        {
            if ($this->useAuth)
            {
                try
                {
                    isys_auth_cmdb_categories::instance()->check_rights_obj_and_category(isys_auth::VIEW, $l_row['isys_obj__id'], 'C__CATG__LOCATION');
                }
                catch (isys_exception_auth $e)
                {
                    $this->m_log->error('Object #' . $l_row['isys_obj__id'] . ': ' . $e->getMessage());
                    continue;
                }
            }

            $l_return[] = ($l_raw ? $l_row : $this->format_by_mapping($this->m_mapping, $l_row));
        }

        return $l_return;
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return isys_api_model_cmdb Returns itself.
     * @throws isys_exception_api
     */
    public function create($p_params)
    {
        throw new isys_exception_api('Creating is not possible here.');
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return isys_api_model_cmdb Returns itself.
     * @throws isys_exception_api
     */
    public function delete($p_params)
    {
        throw new isys_exception_api('Deleting is not possible here.');
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return isys_api_model_cmdb Returns itself.
     * @throws isys_exception_api
     */
    public function update($p_params)
    {
        throw new isys_exception_api('Updating is not possible here.');
    }

    protected function format_by_mapping(array $p_mapping, $p_row)
    {
        // Get mapped result
        $result = parent::format_by_mapping($p_mapping, $p_row);

        // Cast string to integer values
        $result['id'] = (int)$result['id'];
        $result['type'] = (int)$result['type'];
        $result['status'] = (int)$result['status'];
        $result['cmdb_status'] = (int)$result['cmdb_status'];

        return $result;
    }

    /**
     * Constructor
     */
    public function __construct(isys_cmdb_dao $p_dao)
    {
        $this->m_dao = $p_dao;
        parent::__construct();
    }
}
