<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Console\Command\Logbook\ArchiveCommand;

/**
 * Class isys_model_console_logbook
 */
class isys_api_model_console_logbook extends isys_api_model_console
{
    /**
     * Archive old logbook entries
     *
     * @param array $params
     *
     * @return array
     * @throws Exception
     */
    public function archive(array $params = [])
    {
        // Check whether command exists
        $this->commandExists(ArchiveCommand::class);

        return $this->run(ArchiveCommand::NAME, $params['options'], $params['arguments']);
    }
}