<?php

use idoit\Module\Api\Exception\JsonRpc\MethodException;
use idoit\Module\Search\Query\Condition;

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_search implements isys_api_model_interface
{
    /**
     * @param array $p_params
     *
     * @return array
     * @throws \idoit\Module\Search\Query\Exceptions\NoQueryEngineException
     * @throws isys_exception_api
     */
    public function read($p_params)
    {
        global $g_config;

        // Check whether authentication system is active or not
        if ($g_config['use_auth'])
        {
            isys_auth_search::instance()->search();
        }

        if (!isset($p_params['q']))
        {
            throw new isys_exception_api('Missing parameter: "q".', MethodException::CODE);
        }

        $paramMode = '';
        if (isset($p_params['mode']))
        {
            $paramMode = $p_params['mode'];
            switch ($paramMode) {
                case 'deep' :
                    $searchMode = Condition::MODE_DEEP;
                    break;
                case 'normal' :
                case 'auto-deep' :
                default:
                    $searchMode = Condition::MODE_DEFAULT;
                    break;
            }
        } else {
            $searchMode = (int)isys_tenantsettings::get('defaults.search.mode', Condition::MODE_DEFAULT);
            $tenantAutostartDeepSearch = (int)isys_tenantsettings::get('search.global.autostart-deep-search', isys_module_search::AUTOMATIC_DEEP_SEARCH_NONACTIVE);

            if ($tenantAutostartDeepSearch === isys_module_search::AUTOMATIC_DEEP_SEARCH_ACTIVE_EMPTY_RESULT) {
                $paramMode = 'auto-deep';
            } elseif ($tenantAutostartDeepSearch === isys_module_search::AUTOMATIC_DEEP_SEARCH_ACTIVE) {
                $searchMode = Condition::MODE_DEEP;
            }
        }

        $result = $this->getSearchResult($p_params['q'], $searchMode);

        if (empty($result) && ($paramMode === 'auto-deep') && ($searchMode === Condition::MODE_DEFAULT)) {
            $result = $this->getSearchResult($p_params['q'], Condition::MODE_DEEP);
        }

        return $result;
    } // function

    /**
     * @param $queryString
     * @param $searchMode
     *
     * @return \idoit\Module\Search\Query\Protocol\QueryResultItem[]
     * @throws \idoit\Module\Search\Query\Exceptions\NoQueryEngineException
     */
    private function getSearchResult($queryString, $searchMode)
    {
        return \idoit\Module\Search\Query\QueryManager::factory()
            ->attachEngine(new \idoit\Module\Search\Query\Engine\Mysql\SearchEngine())
            ->addSearchKeyword($queryString, 'AND', false, $searchMode)
            ->search()
            ->getResult();
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        ;
    }
}
