<?php

namespace idoit\Module\Api\Endpoint;

/**
 * Helper class for any endpoint related (and recurring) logic.
 */
class Helper
{
    /**
     * Simple static method to help out creating example requests.
     *
     * @param string $method
     * @param array  $parameters
     *
     * @return array
     */
    public static function exampleRequest(string $method, array $parameters = []): array
    {
        $example = [
            'id'      => 1,
            'version' => '2.0',
            'method'  => $method,
            'params'  => $parameters,
        ];

        $example['params']['apikey'] = '{your-api-key}';

        return $example;
    }

    /**
     * Simple static method to help out creating example responses.
     *
     * @param mixed $data
     *
     * @return array
     */
    public static function exampleResponse(mixed $data = null): array
    {
        return [
            'id'      => 1,
            'jsonrpc' => '2.0',
            'result'  => $data
        ];
    }
}
