<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use idoit\Api\JsonRpcResponse;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use Throwable;

/**
 * CMDB abstract object type group endpoint (v2).
 *
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
abstract class AbstractObjectEndpoint extends AbstractCmdbEndpoint
{
    /**
     * @param string $status
     * @param int    $objectId
     * @return JsonRpcResponse
     */
    protected function rank(string $status, int $objectId): JsonRpcResponse
    {
        try {
            $rankResponse = match ($status) {
                'archive' => $this->objectProcessor->archive($objectId),
                'delete' => $this->objectProcessor->delete($objectId),
                'purge' => $this->objectProcessor->purge($objectId),
                'restore' => $this->objectProcessor->restore($objectId),
            };

            return new JsonRpcResponse([
                'success' => true,
                'id'      => $objectId,
                'message' => "Object #{$rankResponse->id} has been {$status}d."
            ]);
        } catch (Throwable $e) {
            return new JsonRpcResponse([
                'success' => false,
                'id'      => $objectId,
                'message' => $e->getMessage()
            ]);
        }
    }
}
