<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Component\Processor\Dto\Object\CreateRequest;
use Idoit\Dto\Serialization\Serializer;
use idoit\Module\Api\Endpoint\Validate;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object save endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Create extends AbstractObjectEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.create.v2', 'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_CREATE', [
            new RequiredParameter('title', Parameter::TYPE_STRING, 'A new title for the object', fn ($title) => trim($title) !== ''),
            new RequiredParameter('objectType', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'The object type for the object', fn ($type) => is_int($type) || (strpos($type, 'C__OBJTYPE__') === 0 && defined($type))),
            new OptionalParameter('sysid', Parameter::TYPE_STRING, 'A new SYS-ID for the object', fn ($title) => trim($title) !== ''),
            new OptionalParameter('category', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'A new category for the object', fn ($category) => is_int($category) || (is_string($category) && trim($category) !== '')),
            new OptionalParameter('purpose', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'A new purpose for the object', fn ($purpose) => is_int($purpose) || (is_string($purpose) && trim($purpose) !== '')),
            new OptionalParameter('description', Parameter::TYPE_STRING, 'A new description for the object'),
            new OptionalParameter('constant', Parameter::TYPE_STRING, 'A constant for the new object', [Validate::class, 'isConstant']),
            new OptionalParameter('status', Parameter::TYPE_INTEGER, 'The "status" of the object, default is "normal"', null, C__RECORD_STATUS__NORMAL),
            new OptionalParameter('cmdbStatus', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'The CMDB-Status for the object', fn ($cmdbStatus) => trim($cmdbStatus) !== ''),
            // @todo Tags?
            // new OptionalParameter('categories', Parameter::TYPE_ARRAY, 'An array of category entries to create for this object'), // @todo  Add validation
        ]);
    }

    /**
     * @param Request $request
     * @return JsonRpcResponse
     * @throws \idoit\Component\Processor\Exception\AuthorizationException
     * @throws \idoit\Component\Processor\Exception\InternalSystemException
     * @throws \idoit\Component\Processor\Exception\ValidationException
     */
    public function request(Request $request): JsonRpcResponse
    {
        $parameters = $request->request->all();
        $title = $parameters['title'];

        // Pass parameters to the DTO (this only works if the parameters have the exact same keys).
        $response = $this->objectProcessor->create(Serializer::fromJson(CreateRequest::class, $parameters));

        // @todo After implementing category processors.
        /*
        foreach ($parameters['categories'] ?? [] as $categoryConstant => $categoryEntries) {
            $categoryProcessor = $cmdbFactory->getCategoryProcessor($categoryConstant);

            foreach ($categoryEntries as $categoryEntry) {
                // @todo Implement try/catch?
                // @todo Add info to response?
                $categoryProcessor->save(null, $objectId, $categoryEntry);
            }
        }
        */

        return new JsonRpcResponse([
            'success' => true,
            'data'    => $response->id,
            'message' => "Object '{$title}' (#{$response->id}) successfully created."
        ]);
    }
}
