<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\Validate;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object delete endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Delete extends AbstractObjectEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.delete.v2', 'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_DELETE', [
            new RequiredParameter('id', Parameter::TYPE_INTEGER, 'LC__ADDON__API__PARAMETER__OBJECT_ID', [Validate::class, 'isId']),
        ]);
    }

    /**
     * @param Request $request
     * @return JsonRpcResponse
     */
    public function request(Request $request): JsonRpcResponse
    {
        return $this->rank('delete', (int)$request->request->get('id'));
    }
}
