<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Component\Processor\Dto\Object\Dto;
use idoit\Component\Processor\Dto\Object\ReadRequest;
use Idoit\Dto\Serialization\Serializer;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Endpoint\Validate;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object read endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Read extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.read.v2', 'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_READ', [
            new RequiredParameter('id', [Parameter::TYPE_INTEGER, Parameter::TYPE_ARRAY], 'LC__ADDON__API__PARAMETER__OBJECT_ID', [Validate::class, 'isIdOrArrayOfIds']),
            // new OptionalParameter('categories', Parameter::TYPE_ARRAY, 'LC__ADDON__API__PARAMETER__CATEGORY_CONSTANTS', fn($categories) => Validate::isArrayOfConstants($categories, 'C__CAT', true), [])
        ]);
    }

    /**
     * @param Request $request
     * @return JsonRpcResponse
     * @throws \idoit\Component\Processor\Exception\AuthorizationException
     * @throws \idoit\Component\Processor\Exception\InternalSystemException
     * @throws \idoit\Component\Processor\Exception\ValidationException
     */
    public function request(Request $request): JsonRpcResponse
    {
        $parameters = $request->request->all();
        $objectResponse = $this->objectProcessor->read(new ReadRequest((array)$parameters['id']));
        $objects = [];

        foreach ($objectResponse->entries as $objectDto) {
            /** @var Dto $objectDto */
            $object = Serializer::toJson($objectDto);

            // @todo After implementing category processors.
            // foreach ($parameters['categories'] as $categoryConstant) {
            //     $object['categories'][$categoryConstant] = $this->getCategoryProcessor($categoryConstant)->readByObject($object['id']);
            // }

            $objects[] = $object;
        }

        return new JsonRpcResponse($objects);
    }
}
