<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\Object;

use Exception;
use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\OptionalParameter;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Component\Processor\Dto\Object\UpdateRequest;
use Idoit\Dto\Serialization\Serializer;
use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use idoit\Module\Api\Endpoint\Validate;
use Symfony\Component\HttpFoundation\Request;

/**
 * CMDB object save endpoint (v2).
 *
 * @see       API-484
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Update extends AbstractCmdbEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition('cmdb.object.update.v2', 'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_UPDATE', [
            new RequiredParameter('id', Parameter::TYPE_INTEGER, 'LC__ADDON__API__PARAMETER__OBJECT_ID', [Validate::class, 'isId']),
            new OptionalParameter('title', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__OBJECT_TITLE', fn($title) => trim($title) !== ''),
            new OptionalParameter('objectType', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'LC__ADDON__API__PARAMETER__OBJECT_TYPE_CONSTANT_OR_ID', fn ($type) => is_int($type) || (strpos($type, 'C__OBJTYPE__') === 0 && defined($type))),
            new OptionalParameter('sysid', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__OBJECT_SYSID', fn($title) => trim($title) !== ''),
            new OptionalParameter('category', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'LC__ADDON__API__PARAMETER__OBJECT_CATEGORY_ID_OR_TITLE', fn($category) => is_int($category) || (is_string($category) && trim($category) !== '')),
            new OptionalParameter('purpose', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'LC__ADDON__API__PARAMETER__OBJECT_PURPOSE_ID_OR_TITLE', fn($purpose) => is_int($purpose) || (is_string($purpose) && trim($purpose) !== '')),
            new OptionalParameter('description', Parameter::TYPE_STRING, 'LC__ADDON__API__PARAMETER__DESCRIPTION', fn($title) => trim($title) !== ''),
            new OptionalParameter('cmdbStatus', [Parameter::TYPE_INTEGER, Parameter::TYPE_STRING], 'The CMDB-Status for the object', fn ($cmdbStatus) => trim($cmdbStatus) !== ''),
            // @todo Tags?
        ]);
    }

    /**
     * @param Request $request
     *
     * @return JsonRpcResponse
     * @throws Exception
     */
    public function request(Request $request): JsonRpcResponse
    {
        $parameters = $request->request->all();

        $response = $this->objectProcessor->update(Serializer::fromJson(UpdateRequest::class, $parameters));

        return new JsonRpcResponse([
            'success' => true,
            'data'    => $response->id,
            'message' => "Object #{$response->id} successfully updated."
        ]);
    }
}
