<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\ObjectType;

use idoit\Api\EndpointDefinition;
use idoit\Api\JsonRpcResponse;
use idoit\Api\Parameter\Parameter;
use idoit\Api\Parameter\RequiredParameter;
use idoit\Module\Api\Endpoint\Helper;
use idoit\Module\Api\Endpoint\Validate;
use isys_auth;
use isys_exception_auth;
use isys_module_system;
use Symfony\Component\HttpFoundation\Request;
use Throwable;

/**
 * CMDB object type delete endpoint (v2).
 *
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Delete extends AbstractObjectTypeEndpoint
{
    public function getDefinition(): EndpointDefinition
    {
        return new EndpointDefinition(
            'cmdb.object-type.delete.v2',
            'LC__ADDON__API__ENDPOINT__CMDB_OBJECT_TYPE_DELETE',
            [
                new RequiredParameter('id', Parameter::TYPE_INTEGER, 'LC__ADDON__API__PARAMETER__ID', [Validate::class, 'isId']),
            ],
            [
                'Basic request'  => Helper::exampleRequest('cmdb.object-type.delete.v2', ['id' => 123]),
            ],
            [
                'Basic response' => Helper::exampleResponse([
                    'success' => true,
                    'id'      => 123,
                    'message' => 'Object type #123 has been deleted.'
                ]),
            ]
        );
    }

    /**
     * @param Request $request
     * @return JsonRpcResponse
     * @throws isys_exception_auth
     */
    public function request(Request $request): JsonRpcResponse
    {
        // @todo Get rid of specific AUTH check, after it was implemented in processor.
        isys_module_system::getAuth()->check(isys_auth::DELETE, 'globalsettings/qcw');

        $id = $request->request->get('id');

        try {
            $this->objectTypeProcessor->purge($id);

            $message = "Object type #{$id} has been deleted.";
        } catch (Throwable $e) {
            $message = $e->getMessage();
        }

        return new JsonRpcResponse([
            'success' => true,
            'id'      => $id,
            'message' => $message
        ]);
    }
}
