<?php

namespace idoit\Module\Api\Endpoint\v2\Cmdb\ObjectTypeGroup;

use idoit\Module\Api\Endpoint\v2\Cmdb\AbstractCmdbEndpoint;
use isys_component_dao_result;

/**
 * CMDB abstract object type group endpoint (v2).
 *
 * @package   idoit\Api
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
abstract class AbstractObjectTypeGroupEndpoint extends AbstractCmdbEndpoint
{
    /**
     * @param int|array|null    $id
     * @param string|array|null $constant
     * @param bool|null         $visible
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    protected function read(int|array|null $id = null, string|array|null $constant = null, bool|null $visible = null): isys_component_dao_result
    {
        $query = 'SELECT * FROM isys_obj_type_group WHERE TRUE';

        if ($id !== null) {
            if (is_int($id)) {
                $id = [$id];
            }

            if (is_array($id) && count($id) > 0) {
                $idList = implode(',', array_map('intval', $id));
                $query .= " AND isys_obj_type_group__id IN ({$idList})";
            }
        }

        if ($constant !== null) {
            if (is_string($constant)) {
                $constant = [$constant];
            }

            if (is_array($constant) && count($constant) > 0) {
                $constantList = implode(',', array_map([$this->daoCmdb, 'convert_sql_text'], $constant));
                $query .= " AND isys_obj_type_group__const IN ({$constantList})";
            }
        }

        if ($visible !== null) {
            $statusNormal = $this->daoCmdb->convert_sql_int(C__RECORD_STATUS__NORMAL);

            if ($visible) {
                $query .= " AND isys_obj_type_group__status = {$statusNormal}";
            } else {
                $query .= " AND isys_obj_type_group__status != {$statusNormal}";
            }
        }

        return $this->daoCmdb->retrieve($query);
    }
}
