<?php

namespace idoit\Module\Api\Model\Cabling;

class Cabling
{
    /**
     * @var Presentation
     */
    private Presentation $presentation;

    /**
     * @var Connector
     */
    private Connector $connector;

    /**
     * @var CiObject
     */
    private CiObject $ciObject;

    /**
     * @param Presentation $presentation
     * @param Connector    $connector
     * @param CiObject     $ciObject
     */
    public function __construct(Presentation $presentation, Connector $connector, CiObject $ciObject)
    {
        $this->presentation = $presentation;
        $this->connector = $connector;
        $this->ciObject = $ciObject;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $return = [];
        foreach (get_object_vars($this) as $key => $value) {
            $return[$key] = $value->flatten();
        }

        return $return;
    }
}
