<?php

namespace idoit\Module\Api\Model\Cabling;

use isys_application;
use isys_cmdb_dao_cable_connection;
use isys_component_database;
use isys_component_template_language_manager;

class CablingProvider
{
    /**
     * @var null|CablingProvider
     */
    private static $instance = null;

    /**
     * @var isys_cmdb_dao_cable_connection
     */
    private isys_cmdb_dao_cable_connection $dao;

    /**
     * @var isys_component_template_language_manager
     */
    private isys_component_template_language_manager $lang;

    /**
     * @throws \Exception
     */
    public function __construct()
    {
        $this->dao = isys_cmdb_dao_cable_connection::instance(isys_application::instance()->container->get('database'));
        $this->lang = isys_application::instance()->container->get('language');
    }

    /**
     * @return CablingProvider
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new CablingProvider();
        }

        return self::$instance;
    }

    /**
     * @param int $cableObjectId
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function getConnections(int $cableObjectId)
    {
        $cableConnectionId = $this->dao->get_cable_connection_id_by_cable_id($cableObjectId);
        if (!$cableConnectionId) {
            return [
                'start' => null,
                'end' => null,
            ];
        }

        $result = $this->dao->get_connection_info($cableConnectionId);
        $cabling = [];
        while($row = $result->get_row()) {
            $presentation = new Presentation($row['isys_obj__title'] . ' > ' . $row['isys_catg_connector_list__title']);
            $connector = new Connector(
                $row['isys_catg_connector_list__id'],
                $row['isys_catg_connector_list__title'],
                $row['isys_catg_connector_list__assigned_category'],
                $row['isys_catg_connector_list__type']
            );

            $objectType = $this->dao->get_object_type($row['isys_obj__isys_obj_type__id']);

            $ciObject = new CiObject(
                $row['isys_obj__id'],
                $row['isys_obj__title'],
                $this->lang->get($objectType['isys_obj_type__title']),
                $objectType['isys_obj_type__const']
            );
            $cabling[] = new Cabling($presentation, $connector, $ciObject);
        }
        return [
            'start' => isset($cabling[0]) ? $cabling[0]->toArray(): null,
            'end' => isset($cabling[1]) ? $cabling[1]->toArray() : null,
        ];
    }
}
