<?php

namespace idoit\Module\Api\Model\Cabling;
class CiObject
{
    /**
     * @var int
     */
    private int $id;

    /**
     * @var string
     */
    private string $title;

    /**
     * @var string
     */
    private string $type;

    /**
     * @var string
     */
    private string $typeConstant;

    /**
     * @param int    $id
     * @param string $title
     * @param string $type
     * @param string $typeConstant
     */
    public function __construct(int $id, string $title, string $type, string $typeConstant)
    {
        $this->id = $id;
        $this->title = $title;
        $this->type = $type;
        $this->typeConstant = $typeConstant;
    }

    /**
     * @return array
     */
    public function flatten()
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'type' => $this->type,
            'typeConstant' => $this->typeConstant,
        ];
    }
}
