<?php

namespace idoit\Module\Api\Model\Cabling;

use isys_application;

class Connector
{
    /**
     * @var int
     */
    private int $id;

    /**
     * @var string
     */
    private string $title;

    /**
     * @var string
     */
    private string $type;

    /**
     * @var string
     */

    private string $inOutput;

    /**
     * @param int    $id
     * @param string $title
     * @param string $type
     */
    public function __construct(int $id, string $title, string $type, int $inOutput)
    {
        $lang = isys_application::instance()->container->get('language');
        $this->id = $id;
        $this->title = $title;
        $this->type = $type;
        $this->inOutput = $inOutput === C__CONNECTOR__OUTPUT ? $lang->get('LC__CATG__CONNECTOR__OUTPUT') : $lang->get('LC__CATG__CONNECTOR__INPUT');
    }

    /**
     * @return array
     */
    public function flatten()
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'type' => $this->type,
            'inOutput' => $this->inOutput,
        ];
    }
}
