<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

/**
 * AbstractCategoryProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
abstract class AbstractCategoryProcessor
{
    /**
     * @var \isys_cmdb_dao_category
     */
    protected $dao;

    /**
     * @var array
     */
    protected $request;

    /**
     * @return array
     */
    public function getAffectedPropertiesByRequest(){
        return [];
    }

    /**
     * @return array
     */
    public function getAffectedPropertiesBySync(){
        return [];
    }

    /**
     * @return array
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param array $request
     */
    public function setRequest($request)
    {
        $this->request = $request;
    }

    /**
     * @return \isys_cmdb_dao_category
     */
    public function getDao()
    {
        return $this->dao;
    }

    /**
     * @param \isys_cmdb_dao_category $dao
     */
    public function setDao($dao)
    {
        $this->dao = $dao;
    }

    /**
     * Convenience method.
     * @return bool
     */
    protected function isWriteRequest(): bool
    {
        return in_array($this->request['option'], ['save', 'update', 'create'], true);
    }

    /**
     * AbstractCategoryProcessor constructor.
     *
     * @param array                   $request
     * @param \isys_cmdb_dao_category $categoryDao
     */
    public function __construct(array $request, \isys_cmdb_dao_category $categoryDao)
    {
        // Store request and dao
        $this->setRequest($request);
        $this->setDao($categoryDao);
    }
}
