<?php

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use isys_application;
use isys_cmdb_dao_category_s_file_object as FileObjectDao;

/**
 * File objects processor
 *
 * @package    idoit\Module\Api\Model\Category
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class FileObjectsProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * Modify api response.
     *
     * @param array $response
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifyResponse(array $response)
    {
        $requestData = $this->getRequest();

        // @see API-407 The 'read' response is almost not useable - so we create it new.
        if ($requestData['option'] === 'read' && $this->getDao() instanceof FileObjectDao) {
            $response = [];

            $language = isys_application::instance()->container->get('language');
            $result = $this->getDao()->get_data(
                null,
                $requestData['object'] ?? $requestData['objID'],
                '',
                null,
                $requestData['status'] ?? C__RECORD_STATUS__NORMAL
            );

            while ($row = $result->get_row()) {
                if (isset($row['isys_catg_manual_list__id']) && $row['isys_catg_manual_list__id']) {
                    $id = (int)$row['isys_catg_manual_list__id'];
                    $objectId = (int)$row['isys_catg_manual_list__isys_obj__id'];
                    $category = 'LC__CMDB__CATG__MANUAL';
                    $categoryConstant = 'C__CATG__MANUAL';
                } elseif (isset($row['isys_catg_file_list__id']) && $row['isys_catg_file_list__id']) {
                    $id = (int)$row['isys_catg_file_list__id'];
                    $objectId = (int)$row['isys_catg_file_list__isys_obj__id'];
                    $category = 'LC__CMDB__CATG__FILE';
                    $categoryConstant = 'C__CATG__FILE';
                } elseif (isset($row['isys_catg_emergency_plan_list__id']) && $row['isys_catg_emergency_plan_list__id']) {
                    $id = (int)$row['isys_catg_emergency_plan_list__id'];
                    $objectId = (int)$row['isys_catg_emergency_plan_list__isys_obj__id'];
                    $category = 'LC__CATG_EMERGENCY_PLAN';
                    $categoryConstant = 'C__CATG__EMERGENCY_PLAN';
                } else {
                    $id = null;
                    $objectId = null;
                    $category = 'unknown';
                    $categoryConstant = '';
                }

                $assignedObject = null;

                if ($objectId) {
                    $objectData = $this->getDao()
                        ->get_object($objectId)
                        ->get_row();

                    $assignedObject = [
                        'id'         => (int)$objectData['isys_obj__id'],
                        'title'      => $language->get($objectData['isys_obj__title']),
                        'sysid'      => $objectData['isys_obj__sysid'],
                        'type'       => $objectData['isys_obj_type__const'],
                        'type_title' => $language->get($objectData['isys_obj_type__title'])
                    ];
                }

                $response[] = [
                    'id'               => $id,
                    'objID'            => $objectId,
                    'category'         => $language->get($category),
                    'category_const'   => $categoryConstant,
                    'assigned_objects' => $assignedObject
                ];
            }
        }

        return $response;
    }
}
