<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use isys_application;
use isys_helper_link;
use Throwable;

/**
 * Image processor
 *
 * @package idoit\Module\Api\Model\Category
 */
class ImageProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * @param array $response
     *
     * @return array
     * @throws \Exception
     */
    public function modifyResponse(array $response)
    {
        // Get request
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (is_array($request) && $request['option'] === 'read' && count($response) > 0) {
            $routeGenerator = isys_application::instance()->container->get('route_generator');

            foreach ($response as &$entry) {
                $objectId = (int)($entry['object'] ?? $entry['objID']);

                if (!is_array($entry['image'])) {
                    $entry['image'] = [];
                }

                // @see API-516 Implement 'url' and 'absolute_url' data.
                try {
                    $entry['image']['url'] = $routeGenerator->generate('cmdb.object.image', ['objectId' => $objectId]);
                    $entry['image']['absolute_url'] = $routeGenerator->generate('cmdb.object.image', ['objectId' => $objectId], $routeGenerator::ABSOLUTE_URL);
                } catch (Throwable $e) {
                    // @todo API-505 this is a workaround and should not be necessary, after the bootstrapping has been unified.
                    $entry['image']['url'] = rtrim(isys_application::instance()->www_path, '/') . '/cmdb/object/image/' . $objectId;
                    $entry['image']['absolute_url'] = rtrim(isys_helper_link::get_base(), '/') . '/cmdb/object/image/' . $objectId;
                }

                unset($entry['image_selection']);
            }

        }

        return array_values($response);
    }
}
