<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * IpAddressesProcessor
 *
 * @package idoit\Module\Api\Model\Category
 */
class Layer2NetAssignedLogicalPortProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * @return array
     */
    public function getAffectedPropertiesBySync()
    {
        return [
            'isys_catg_log_port_list__id',
        ];
    }

    /**
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        // Get request information.
        $request = $this->getRequest();

        if (in_array($request['option'], ['save', 'update', 'create'], true) && isset($syncData['properties']['isys_catg_log_port_list__id']['value'])) {
            // @see API-379 Also the key needs to be updated.
            $syncData['properties']['isys_catg_log_port_list__id']['ref_id'] = $syncData['properties']['isys_catg_log_port_list__id']['value'];
        }

        return $syncData;
    }
}
