<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.10.2
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * IpProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class PersonAssignedGroupsProcessor extends AbstractCategoryProcessor implements ResponseModifier
{
    /**
     * Modify api response
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        // Get request
        $request = $this->getRequest();

        // Check whether api request is 'read' and response object has results
        if (is_array($request) && $request['option'] === 'read' && is_array($response) && count($response) > 0) {
            $cmdbDao = \isys_application::instance()->container->get('cmdb_dao');

            // Here we set the correct "id" so that the users will know which ID to purge.
            foreach ($response as &$responseItem) {
                $sql = 'SELECT isys_person_2_group__id AS id
                    FROM isys_person_2_group 
                    WHERE isys_person_2_group__isys_obj__id__person = ' . $cmdbDao->convert_sql_id($responseItem['objID']) . ' 
                    AND isys_person_2_group__isys_obj__id__group = ' . $cmdbDao->convert_sql_id($responseItem['connected_object']['id']) . ' 
                    LIMIT 1;';

                $responseItem['id'] = (int)$cmdbDao->retrieve($sql)->get_row_value('id');
            }
        }

        return array_values($response);
    }
}
