<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Oscar Pohl <opohl@i-doit.com>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Component\Helper\Ip;
use idoit\Exception\Exception;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;
use isys_application;
use isys_cmdb_dao_category_g_ip;

/**
 * Class VirtualSwitchProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class VirtualSwitchProcessor extends AbstractCategoryProcessor implements RequestModifier, SyncModifier
{
    /**
     * @var
     */
    private $requestData;

    /**
     * @return array
     */
    public function getAffectedPropertiesByRequest()
    {
        return [
            'portgroup',
            'serviceconsoleports',
            'vmkernelports',
        ];
    }

    /**
     * @return array
     */
    public function getAffectedPropertiesBySync()
    {
        return $this->getAffectedPropertiesByRequest();
    }

    /**
     * @param array $request
     *
     * @return array
     */
    public function modifyRequest(array $request) {
        $this->requestData = [
            'portgroup' => $request['data']['portgroup'],
            'serviceconsoleports' => $request['data']['serviceconsoleports'],
            'vmkernelports' => $request['data']['vmkernelports'],
        ];
        unset($request['data']['portgroup'], $request['data']['serviceconsoleports'], $request['data']['vmkernelports']);
        return $request;
    }

    /**
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData) {
        $ipList = $this->getAddressList();
        foreach ($this->requestData as $key => $property) {
            $syncData['properties'][$key][C__DATA__VALUE] = [];
            if (is_array($property)) {
                foreach ($property as $entry) {
                    if (is_array($entry)) {
                        if ($key !== 'portgroup') {
                            $entry[1] = $this->findAddressID($entry[1], $ipList);
                        }
                        $syncData['properties'][$key][C__DATA__VALUE][] = $entry;
                    }
                }
            }
        }
        return $syncData;
    }

    /**
     * @param $address
     * @param $ipList
     *
     * @return integer
     */
    private function findAddressID($address, $ipList) {
        if (empty($ipList)) {
            return null;
        }
        if (filter_var($address, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) && in_array($address, $ipList)) {
            return array_search($address, $ipList);
        }
        $fullIPv6 = Ip::validate_ipv6($address);
        if ($fullIPv6 && in_array($fullIPv6, $ipList)) {
            return array_search($fullIPv6, $ipList);
        }
        if (key_exists($address, $ipList)) {
            return $address;
        }
        return null;
    }

    private function getAddressList() {
        $result = [];
        try {
            $ips = isys_cmdb_dao_category_g_ip::instance(isys_application::instance()->container->get('database'))->get_ips_by_obj_id($this->getRequest()['objID']);
            while ($ip = $ips->get_row()) {
                $result[$ip['isys_catg_ip_list__id']] = $ip['isys_cats_net_ip_addresses_list__title'];
            }
        } catch (\Exception $e) {
        }
        return $result;
    }
}
