<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\ResponseModifier;
use isys_cmdb_dao_category_g_wan;
use isys_request;

/**
 * Class ModelProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class WanProcessor extends AbstractCategoryProcessor implements RequestModifier, ResponseModifier
{
    /**
     * @return array
     */
    public function getAffectedPropertiesByRequest()
    {
        return [
            'router',
            'net',
        ];
    }

    /**
     * Modify api request.
     *
     * @param array $request
     *
     * @return array
     * @throws \isys_exception_dao_cmdb
     * @throws \isys_exception_database
     */
    public function modifyRequest(array $request)
    {
        if (in_array($request['option'], ['save', 'update'], true)) {
            /** @var isys_cmdb_dao_category_g_wan $dao */
            $dao = $this->getDao();
            $categoryData = $dao->get_data(null, $request['objID'])->get_row();

            $requestObject = isys_request::factory()->set_category_data_id($categoryData['isys_catg_wan_list__id']);

            if (!isset($request['data']['router'])) {
                $request['data']['router'] = $dao->retrieveAssignedRouters($requestObject);
            }

            if (!isset($request['data']['net'])) {
                $request['data']['net'] = $dao->retrieveAssignedNets($requestObject);
            }
        }

        return $request;
    }

    /**
     * Modify api response.
     *
     * @param array $response
     *
     * @return array
     */
    public function modifyResponse(array $response)
    {
        if (\is_array($response)) {
            foreach ($response as &$row) {
                // @see  API-194  Instead of `false` we expect `null`.
                if ($row['router'] === false) {
                    $row['router'] = null;
                }

                // @see  API-194  Instead of `false` we expect `null`.
                if ($row['net'] === false) {
                    $row['net'] = null;
                }
            }
        }

        return $response;
    }
}
