<?php

namespace idoit\Module\Api\Model\External\CategoryStrategy;

use idoit\Module\Api\Model\External\Push\Entry;
use idoit\Module\Api\Model\External\Handler\Category;
use idoit\Module\Api\Model\External\Handler\CiObject;
use idoit\Module\Cmdb\Component\SyncMerger\Config;
use idoit\Module\Cmdb\Component\SyncMerger\Merger;
use idoit\Module\Cmdb\Component\SyncNormalizer\Config as NormalizerConfig;
use idoit\Module\Cmdb\Component\SyncNormalizer\Normalizer;
use isys_cmdb_dao_category;
use isys_import_handler_cmdb;

abstract class AbstractCategoryStrategy
{
    protected const STRATEGY = '';

    abstract protected function prepareMultivalue(isys_cmdb_dao_category $dao, CiObject $ciObject, array $entries): array;

    /**
     * @param string $strategy
     *
     * @return bool
     */
    public function isApplicable(string $strategy): bool
    {
        return $strategy === static::STRATEGY;
    }
}