<?php

namespace idoit\Module\Api\Model\External\CategoryStrategy;

use idoit\Module\Api\Model\External\Logger;
use idoit\Module\Api\Model\External\Push\Entry;
use idoit\Module\Api\Model\External\Handler\Category;
use idoit\Module\Api\Model\External\Handler\CiObject;
use idoit\Module\Api\PushIdentifier\PushIdentifier;
use idoit\Module\Cmdb\Component\SyncMerger\Config;
use idoit\Module\Cmdb\Component\SyncMerger\Merger;
use idoit\Module\Cmdb\Component\SyncNormalizer\Config as NormalizerConfig;
use idoit\Module\Cmdb\Component\SyncNormalizer\Normalizer;
use isys_application;
use isys_cmdb_dao_category;
use isys_import_handler_cmdb;

class Create extends AbstractCategoryStrategy implements CategoryStrategyInterface
{
    protected const STRATEGY = 'create';

    /**
     * @param isys_cmdb_dao_category $dao
     * @param CiObject               $ciObject
     * @param array                  $entries
     *
     * @return array
     */
    public function prepare(isys_cmdb_dao_category $dao, CiObject $ciObject, array $entries): array
    {
        $logger = Logger::instance();

        if ($dao->is_multivalued()) {
            $logger->debug("Handling multi value category.");
            return $this->prepareMultivalue($dao, $ciObject, $entries);
        }
        $logger->debug("Handling single value category.");

        $entry = current($entries);
        $externalType = "{$ciObject->getExtType()}/{$ciObject->getExtId()}/{$dao->get_category_const()}";
        $externalId = key($entries);

        $categoryEntry = new Category($ciObject, $dao, $externalType, $dao->get_category_const());
        $refId = $categoryEntry->findRefIdByExternalId($externalId);
        $categoryEntryId = $categoryEntry->findSingleValueEntryId();

        if ($refId === $categoryEntryId && $categoryEntryId !== null) {
            $logger->info("Entry for custom id {$externalId} already exists. Skipping entry.");
            return [];
        }

        if ($refId === null && $categoryEntryId) {
            $logger->info("Push identifier for custom id {$externalId} does not exists. Recreate Push identifier.");
            $categoryEntry->createIdentifier($externalId, $categoryEntryId);
            return [];
        }

        $refId = $categoryEntry->create();
        $logger->info("New category entry {$refId} created for custom id {$externalId}.");
        return [
            $categoryEntry
                ->createIdentifier($externalId, $refId)
                ->buildEntry($refId, $entry, true)
        ];
    }

    /**
     * @param isys_cmdb_dao_category $dao
     * @param array                  $entries
     *
     * @return array
     */
    protected function prepareMultivalue(isys_cmdb_dao_category $dao, CiObject $ciObject, array $entries): array
    {
        $data = [];

        $externalType = "{$ciObject->getExtType()}/{$ciObject->getExtId()}/{$dao->get_category_const()}";
        $categoryEntry = new Category($ciObject, $dao, $externalType, $dao->get_category_const());
        $existingExternalIds = $categoryEntry->find();
        $logger = Logger::instance();

        foreach ($entries as $externalId => $entry) {
            if (in_array($externalId, $existingExternalIds)) {
                $logger->info("Entry for custom id {$externalId} already exists. Skipping entry.");
                continue;
            }

            $refId = $categoryEntry->create();
            $logger->info("New category entry {$refId} created for custom id {$externalId}.");

            $data[] = $categoryEntry
                ->createIdentifier($externalId, $refId)
                ->buildEntry($refId, $entry, true);
        }

        return $data;
    }
}
