<?php

namespace idoit\Module\Api\Model\External\Handler;

use idoit\Module\Api\PushIdentifier\PushIdentifier;
use isys_application;
use isys_auth;
use isys_auth_cmdb;

class CiObject
{
    /**
     * @var string
     */
    protected string $class;

    /**
     * @var string
     */
    protected string $title;

    /**
     * @var string
     */
    protected string $extType;

    /**
     * @var string
     */
    protected string $extId;

    /**
     * @var string
     */
    protected string $refType;

    /**
     * @var int|null
     */
    protected ?int $refId;

    /**
     * @var int|null
     */
    protected ?int $classId;

    /**
     * @param string $class
     * @param string $title
     */
    public function __construct(string $class, string $title, string $extType, string $extId, string $refType, ?int $refId = null)
    {
        $this->class = $class;
        $this->title = $title;
        $this->extType = $extType;
        $this->extId = $extId;
        $this->refId = $refId;
        $this->refType = $refType;
    }

    /**
     * @return string
     */
    public function getClass(): string
    {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getExtType(): string
    {
        return $this->extType;
    }

    /**
     * @return string
     */
    public function getExtId(): string
    {
        return $this->extId;
    }

    /**
     * @return string
     */
    public function getRefType(): string
    {
        return $this->refType;
    }

    /**
     * @return int|null
     */
    public function getRefId(): ?int
    {
        return $this->refId;
    }

    /**
     * @return int|null
     */
    public function getClassId(): ?int
    {
        return $this->classId;
    }

    /**
     * @return $this
     * @throws \Exception
     */
    public function find(): CiObject
    {
        $externalType = $this->extType;
        $externalId = $this->extId;
        $identifierData = (PushIdentifier::instance(isys_application::instance()->container->get('database')))
            ->findReferences($externalType, $externalId);

        if (!empty($identifierData)) {
            $this->refId = current($identifierData)['referenceId'];
            $this->classId = isys_application::instance()->container->get('cmdb_dao')->getObjectTypeId($this->getClass());
            return $this;
        }

        return $this;
    }

    /**
     * @return $this
     * @throws \isys_exception_auth
     * @throws \isys_exception_general
     */
    public function create(): CiObject
    {
        $cmdbDao = isys_application::instance()->container->get('cmdb_dao');
        $objectTypeId = $cmdbDao->getObjectTypeId($this->class);

        if (isys_auth_cmdb::instance()->obj_in_type(isys_auth::CREATE, $this->class)) {
            $this->refId = $cmdbDao->insert_new_obj($objectTypeId, null, $this->title, null, C__RECORD_STATUS__NORMAL);
            $this->classId = $objectTypeId;
        }
        return $this;
    }

    /**
     * @return $this
     * @throws \Exception
     */
    public function createIdentifier(): CiObject
    {
        if ($this->refId) {
            (PushIdentifier::instance(isys_application::instance()->container->get('database')))
                ->createReference(
                    $this->extType,
                    $this->extId,
                    PushIdentifier::OBJECT,
                    $this->refId,
                    isys_application::instance()->container->get('session')->get_current_username()
                );
        }
        return $this;
    }
}
