<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Response;

/**
 * Class ResponseStore
 *
 * @package idoit\Module\Api\Response
 */
class ResponseStore
{
    /**
     * @var RpcResponse[]
     */
    protected $responseStore;

    /**
     * Add response to store
     *
     * @param RpcResponse $response
     */
    public function addResponse(RpcResponse $response)
    {
        $this->responseStore[] = $response;
    }

    /**
     * Get all responses
     *
     * @return RpcResponse[]
     */
    public function getResponses()
    {
        return $this->responseStore;
    }
}