<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Response;

/**
 * Class RpcErrorResponse
 *
 * @package idoit\Module\Api\Response
 */
class RpcErrorResponse extends RpcResponse
{

    /**
     * Error data
     *
     * @var array
     */
    protected $error;

    /**
     * Get error data
     *
     * @return array
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * Set error data
     *
     * @param array $error
     *
     * @return RpcErrorResponse
     */
    public function setError($error)
    {
        $this->error = $error;

        return $this;
    }

    public function getResponse()
    {
        return [
            'id'      => $this->getId(),
            'jsonrpc' => '2.0',
            'error'   => $this->getError(),
        ];
    }

    /**
     * RpcErrorResponse constructor.
     *
     * @param int    $id
     * @param string $version
     * @param int    $code
     * @param string $message
     * @param array  $data
     */
    public function __construct($id, $version, $code, $message, $data)
    {
        $this->setError([
            'code'    => $code,
            'message' => $message,
            'data'    => $data,
        ])
            ->setId($id)
            ->setVersion($version);
    }
}