<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Session;

use isys_application;

/**
 * Class SystemUserSession
 *
 * @package idoit\Module\Api
 */
class SystemUserSession extends UserSession
{
    /**
     * Login
     *
     * @throws \isys_exception_api
     * @throws \Exception
     */
    public function login()
    {
        // Check whether requirements are met
        if (empty($this->getApiKey())) {
            throw new \Exception('Please provide a valid apikey information to create a user session.');
        }

        // Initialize session related data
        $this->initialize();

        $session = $this->getSessionComponent();

        // Check whether presistence is wanted and session exists already
        if ($this->isPersistent() && !empty($this->getSessionId())) {
            // Login via sessionId
            return $session->apikey_login($this->getApiKey(), null, $this->getSessionId());
        }

        // Reqular login via api key, username and password
        if ($session->apikey_login($this->getApiKey())) {
            // Set sessionId and userId
            $this->setSessionId($session->get_session_id())
                ->setUserId($session->get_user_id());

            return true;
        }

        return false;
    }

    /**
     * Get user id by credentials
     *
     * @param string $username
     * @param string $password
     *
     * @return int
     * @throws \Exception
     */
    public function getUserIdByCredentials($username, $password)
    {
        $db = isys_application::instance()->container->get('database');

        $sql = "SELECT isys_obj__id FROM isys_obj
            INNER JOIN isys_cats_person_list ON isys_obj__id = isys_cats_person_list__isys_obj__id
            WHERE BINARY LOWER(isys_cats_person_list__title) = LOWER('systemapi') 
            AND isys_cats_person_list__user_pass = '' 
            AND isys_obj__status = " . ((int)C__RECORD_STATUS__NORMAL) . ';';

        $resource = $db->query($sql);

        if ($db->num_rows($resource)) {
            return (int)$db->fetch_row_assoc($resource)['isys_obj__id'];
        }

        // @see ID-6511 Don't throw an exception, because this will break the API for all users that authenticate via LDAP.
        return 0;
    }
}
