<?php

namespace idoit\Module\Api\SettingPage;

use idoit\Module\Api\Endpoint\v2\System\Endpoints\Read;
use idoit\Module\System\SettingPage\SettingPage;
use isys_auth;
use isys_component_template_navbar;
use isys_module_api;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class CustomTranslation
 *
 * @package idoit\Module\System\SettingPage
 */
class EndpointDefinition extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return void
     * @throws \isys_exception_auth
     */
    public function renderPage($navMode)
    {
        // Check right system.
        isys_module_api::getAuth()->check(isys_auth::VIEW, 'CATEGORIES_ATTRIBUTES');

        $definition = [];
        $endpointDefinition = (new Read())->request(new Request())->getData();

        // Prepare the endpoints a bit to get them more structured for the GUI.
        foreach ($endpointDefinition as $name => $endpoint) {
            [$context, $subject] = explode('.', $name);
            $key = ucwords("{$context} {$subject}");

            if (!isset($definition[$key])) {
                $definition[$key] = [];
            };

            // 'var_export' the parameter default values, so that smarty does not need to do it (will cause problems in Smarty v5).
            $endpoint['parameters']['required'] = array_map(function ($parameter) {
                $parameter['types'] = implode(', ', $parameter['types']);

                return $parameter;
            }, $endpoint['parameters']['required']);

            $endpoint['parameters']['optional'] = array_map(function ($parameter) {
                $parameter['types'] = implode(', ', $parameter['types']);
                $parameter['defaultValue'] = var_export($parameter['default-value'], true);

                return $parameter;
            }, $endpoint['parameters']['optional']);

            $definition[$key][$name] = $endpoint;
        }

        isys_component_template_navbar::getInstance()
            ->append_button('LC__ADDON__API__ENDPOINT_DOCUMENTATION__EXPAND_ALL', 'expand-all', [
                'icon'                => 'axialis/user-interface/angle-down-small.svg',
                'js_onclick'          => '',
                'navmode'             => 'expand-all'
            ])
            ->append_button('LC__ADDON__API__ENDPOINT_DOCUMENTATION__COLLAPSE_ALL', 'collapse-all', [
                'icon'                => 'axialis/user-interface/angle-up-small.svg',
                'js_onclick'          => '',
                'navmode'             => 'collapse-all'
            ]);

        $this->tpl
            ->assign('definition', $definition)
            ->assign('content_title', $this->lang->get('LC__ADDON__API__ENDPOINT_DOCUMENTATION'))
            ->include_template('contentbottomcontent', isys_module_api::getPath() . '/templates/endpoint-definition.tpl');
    }
}
