<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;

/**
 * Class Date
 *
 * @package idoit\Module\Api\Validation\Property
 */
class Date extends DateTime
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();

        parent::validate();

        if (strpos($value, ':') !== false) {
            throw new ValidationException($this->getPropertyType(), 'Property type is date but datetime is given.');
        }

        return true;
    }
}
