<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class DateTime
 *
 * @package idoit\Module\Api\Validation\Property
 */
class DateTime extends PropertyValidation
{
    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();

        // @see API-289
        if (isys_strlen($value) === 0) {
            return true;
        }

        if (!is_string($value) || (strtotime($value) === false)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be a valid ISO formatted date string.');
        }

        // Check for right date format: Y-m-d H:i:s
        preg_match('/\d\d\d\d-\d\d-\d\d( \d\d:\d\d:\d\d)?/', $value, $matches);

        if (empty($matches)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be a valid ISO formatted date string.');
        }

        return true;
    }
}
