<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Oscar Pohl <opohl@i-doit.de>
 * @version    1.12.2
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;

class N2M extends ObjectBrowser
{
    /**
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        // @see  API-275  This is only for the Alias Property in the global IP category
        if ($this->getTitle() === 'aliases') {
            foreach ($this->getValue() as $value) {
                if (isset($value['host'], $value['domain'])) {
                    continue;
                }
                throw new ValidationException($this->getPropertyType(), 'All aliases have to have a host and a domain.');
            }
            return true;
        }
        return parent::validate();
    }
}