<div id="endpoint-definition">
    [{foreach $definition as $context => $endpoints}]
    <h1>[{$context}]</h1>
        [{foreach $endpoints as $name => $endpoint}]
        <div class="mb10">
            <div class="p5 bg-neutral-200 display-flex align-items-center">
                <button type="button" class="btn btn-secondary" data-role="trigger" data-tooltip="1" title="[{isys type="lang" ident="LC__UNIVERSAL__TOGGLE_VIEW"}]">
                    <img src="[{$dir_images}]axialis/user-interface/angle-right-small.svg" alt="">
                </button>
                <code class="select-all ml20 mr20">[{$name}]</code>
                <span>[{$endpoint.description}]</span>
            </div>
            <div class="p10 hide" data-role="body">
                <h2 class="mb15">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__PARAMETERS"}]</h2>

                [{if $endpoint.parameters.required || $endpoint.parameters.optional}]
                <table class="mb20 border border-neutral-200">
                    <colgroup>
                        <col style="width: 200px" />
                        <col style="width: 400px" />
                        <col style="width: 100px" />
                    </colgroup>
                    <thead>
                    <tr>
                        <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__TABLE__NAME"}]</th>
                        <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__TABLE__DESCRIPTION"}]</th>
                        <th>[{isys type="lang" ident="LC__ADDON__API__ATTRIBUTE_DOCUMENTATION__TABLE__DEFAULT"}]</th>
                    </tr>
                    </thead>
                    <tbody>
                    [{foreach $endpoint.parameters.required as $parameter => $definition}]
                        <tr>
                            <td>
                                <code>[{$parameter}]</code>
                                <span class="ml10 text-red">*[{isys type="lang" ident="LC__ADDON__API__PARAMETER__REQUIRED"}]</span><br />
                                [{$definition.types}]
                            </td>
                            <td>[{$definition.description}]</td>
                            <td>-</td>
                        </tr>
                    [{/foreach}]
                    [{foreach $endpoint.parameters.optional as $parameter => $definition}]
                        <tr>
                            <td>
                                <code>[{$parameter}]</code><br />
                                [{$definition.types}]
                            </td>
                            <td>[{$definition.description}]</td>
                            <td><code>[{$definition.defaultValue}]</code></td>
                        </tr>
                    [{/foreach}]
                    </tbody>
                </table>
                [{else}]
                <p class="mb20">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__NO_PARAMETERS"}]</p>
                [{/if}]

                <h2 class="mt20 mb15">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__REQUEST_EXAMPLES"}]</h2>
                [{foreach $endpoint['example-request'] as $description => $request}]
                <div class="mt10 p10 bg-neutral-200 text-bold">[{$description}]</div>
                <div class="border border-neutral-200 p10 code-highlight">
                    <div>[{json_encode($request, JSON_PRETTY_PRINT)}]</div>
                </div>
                [{foreachelse}]
                <p class="mb20">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__CURRENTLY_NO_EXAMPLES"}]</p>
                [{/foreach}]

                <h2 class="mt20 mb15">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__RESPONSE_EXAMPLES"}]</h2>
                [{foreach $endpoint['example-response'] as $description => $response}]
                <div class="mt10 p10 bg-neutral-200 text-bold">[{$description}]</div>
                <div class="p10 code-highlight">
                    <div>[{json_encode($response, JSON_PRETTY_PRINT)}]</div>
                </div>
                [{foreachelse}]
                <p class="mb20">[{isys type="lang" ident="LC__ADDON__API__ENDPOINT_DOCUMENTATION__CURRENTLY_NO_EXAMPLES"}]</p>
                [{/foreach}]
            </div>
        </div>
        [{/foreach}]
    [{/foreach}]
</div>

<style>
    #endpoint-definition {
        margin: 20px;
    }

    #endpoint-definition h1 {
        margin-top: 30px;
        margin-bottom: 20px;
    }

    #endpoint-definition code.select-all {
        color: #050;
        user-select: all;
    }

    #endpoint-definition .code-highlight {
        background-color: #141414
    }

    #endpoint-definition table {
        table-layout: fixed;
        border-collapse: collapse;
    }

    #endpoint-definition table thead th {
        background-color: #e6e7e7; /* neutral-200 */
        text-align: left;
    }

    #endpoint-definition table thead th,
    #endpoint-definition table tbody td {
        padding: 10px;
        border-bottom: 1px solid #e6e7e7; /* neutral-200 */
    }
</style>

<script>
    (() => {
        const $endpointDefinition = $('endpoint-definition');
        const $expandAllButton = $('navbar_item_expand-all');
        const $collapseAllButton = $('navbar_item_collapse-all');

        $endpointDefinition.on('click', '[data-role="trigger"]', (ev) => {
            const $button = ev.findElement('button');
            const $container = $button.up('div').next('div');

            if ($container.toggleClassName('hide').hasClassName('hide')) {
                $button.down('img').writeAttribute('src', '[{$dir_images}]axialis/user-interface/angle-right-small.svg');
            } else {
                $button.down('img').writeAttribute('src', '[{$dir_images}]axialis/user-interface/angle-down-small.svg');
            }
        });

        $expandAllButton.on('click', () => {
            // Only select the currently hidden containers
            const $hiddenDefinitions = $endpointDefinition.select('[data-role="body"].hide');

            for (let i in $hiddenDefinitions) {
                if (!$hiddenDefinitions.hasOwnProperty(i)) {
                    continue;
                }

                $hiddenDefinitions[i].up('div').down('[data-role="trigger"]').simulate('click');
            }
        });

        $collapseAllButton.on('click', () => {
            // Only select the containers that are currently shown.
            const $hiddenDefinitions = $endpointDefinition.select('[data-role="body"]:not(.hide)');

            for (let i in $hiddenDefinitions) {
                if (!$hiddenDefinitions.hasOwnProperty(i)) {
                    continue;
                }

                $hiddenDefinitions[i].up('div').down('[data-role="trigger"]').simulate('click');
            }
        });

        idoit.Require.requireQueue(['ace'], () => {

            $endpointDefinition.select('.code-highlight').each(($codeSnippet) => {
                window.ace.edit($codeSnippet.down('div'), {
                    theme:               'ace/theme/twilight',
                    mode:                'ace/mode/javascript',
                    maxLines:            45,
                    readOnly:            true,
                    highlightActiveLine: false,
                    printMargin:         false,
                    fontSize:            12
                });
            });

        });
    })();
</script>
