<?php

namespace idoit\Module\Cabling\Export;

use idoit\Component\Csv\Writer;
use idoit\Module\Cabling\Model\Cabling;
use isys_application as App;
use isys_tenantsettings;
use SplTempFileObject;

/**
 * GraphML export class.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class CSV extends Main
{
    /**
     * @var Writer
     */
    private $csv;

    /**
     * @var array
     */
    private $data = [];

    /**
     * @var array
     */
    private $exportedObjects = [];

    /**
     * @return $this
     */
    public function prepare()
    {
        $this->csv = Writer::createFromFileObject(new SplTempFileObject);

        return $this;
    }

    /**
     * @return $this
     */
    public function export()
    {
        // First we load the necessary data.
        $cablingDao = Cabling::instance(App::instance()->container->get('database'));
        $root       = $cablingDao->getSourceObject($this->objectId);
        $this->data = $cablingDao->resolve($this->objectId, true);

        // How should something like this be displayed in CSV:
        /*
         *                       /--[ Socket 1 ]-+--[ PC 01 ]-- - -
         *                      |                 \-[ PC 02 ]-- - -
         *  --[ Patchpanel 01 ]-+---[ Socket 2 ]-- - -
         *                       \--[ Socket 3 ]-- - -
         */

        $this->exportedObjects[$root['objectId']] = true;

        $this->writeOutput();

        return $this;
    }

    /**
     *
     */
    public function send()
    {
        $this->csv->output($this->filename . '.csv');
    }

    /**
     *
     */
    private function prepareLeftStructure ()
    {
        // @todo  Implement logic
    }

    /**
     *
     */
    private function prepareRightStructure ()
    {
        // @todo  Implement logic
    }

    /**
     *
     */
    private function writeOutput ()
    {
        // @todo  Implement logic
    }
}
