<?php

/**
 * i-doit
 *
 * Cabling export popup.
 *
 * @package     modules
 * @subpackage  pro
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.10.0
 */
class isys_popup_cabling_export extends isys_component_popup
{
    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template &$p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        $l_url_params = C__CMDB__VISUALIZATION_VIEW . '=' . $_GET[C__CMDB__VISUALIZATION_VIEW] . '&' .
            C__CMDB__VISUALIZATION_TYPE . '=' . $_GET[C__CMDB__VISUALIZATION_TYPE];

        $l_button_options = [
            'id'                => $p_params['name'],
            'icon'              => isys_application::instance()->www_path . 'images/icons/silk/disk.png',
            'p_bInfoIconSpacer' => 0,
            'p_onClick'         => $this->process_overlay($l_url_params, 500, 450, $p_params),
            'type'              => 'button',
            'p_strTitle'        => $this->language->get('LC__MODULE__CABLING__VIS__EXPORT')
        ];

        return isys_factory::get_instance('isys_smarty_plugin_f_button')
            ->navigation_edit($this->template, $l_button_options);
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  null
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $l_rules = [];

        $objectTitle = '';
        $rootObjectId = (int)$_POST['selectedObjectId'];

        $inputConnectors = [];
        $outputConnectors = [];

        if ($rootObjectId > 0) {
            $connectionResult = \isys_cmdb_dao_category_g_connector::instance($this->database)
                ->get_data(null, $rootObjectId, '', null, C__RECORD_STATUS__NORMAL);

            while ($connector = $connectionResult->get_row()) {
                if ($connector['isys_catg_connector_list__type'] == C__CONNECTOR__INPUT) {
                    $inputConnectors[$connector['isys_catg_connector_list__id']] = [
                        'id'         => $connector['isys_catg_connector_list__id'],
                        'title'      => $connector['isys_catg_connector_list__title'],
                        'connTypeId' => $connector['isys_catg_connector_list__isys_connection_type__id'],
                        'siblings'   => []
                    ];
                } else {
                    $outputConnectors[$connector['isys_catg_connector_list__id']] = [
                        'id'         => $connector['isys_catg_connector_list__id'],
                        'title'      => $connector['isys_catg_connector_list__title'],
                        'connTypeId' => $connector['isys_catg_connector_list__isys_connection_type__id'],
                        'sibling'    => $connector['isys_catg_connector_list__isys_catg_connector_list__id']
                    ];
                }

                $objectTitle = $connector['isys_obj__title'];
            }
        }

        // Attach all outputs to the according inputs.
        foreach ($outputConnectors as $i => $connector) {
            if (isset($inputConnectors[$connector['sibling']])) {
                $inputConnectors[$connector['sibling']]['siblings'][] = $connector;

                // Remove the entry.
                unset($outputConnectors[$i]);
            }
        }

        $this->template->activate_editmode()
            ->assign('objectSelected', $rootObjectId > 0)
            ->assign('objectTitle', $objectTitle)
            ->assign('exportURL', isys_application::instance()->www_path . 'cabling/export/')
            ->assign('inputConnectors', $inputConnectors)
            ->assign('outputConnectors', $outputConnectors)
            ->assign('exportURL', isys_application::instance()->www_path . 'cabling/export/')
            ->smarty_tom_add_rules('tom.popup.cabling', $l_rules)
            ->display(isys_module_cabling::getPath() . 'templates/popup/cabling_export.tpl');
        die;
    }
}
