// [{literal}] Ignore smarty parsing.

/**
 * i-doit cabling visualization javascript base class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.ConnectorPopup = Class.create({
    $element: null,
    data:     [],
    options:  {},
    
    getData: function () {
        return this.data;
    },
    
    setData: function (data) {
        this.data = data;
        
        this.updateControls();
        
        return this;
    },
    
    getOption: function (option) {
        return this.options[option];
    },
    
    setOption: function (option, value) {
        this.options[option] = value;
        
        return this;
    },
    
    initialize: function ($el, options) {
        this.$element             = $el;
        this.$connectorCounter    = this.$element.down('p');
        this.$connectorTypeSelect = $('cabling_connector_types');
        this.$applyButton         = $('cabling-visualization-connector-control-accept');
        this.$cancelButton        = $('cabling-visualization-connector-control-cancel');
        
        this.options = {
            connectorTypeData: {},
            onShow:            null,
            onHide:            null,
            onApply:           null,
            onCancel:          null
        };
        
        Object.extend(this.options, options || {});
        
        // Store the "apply button" original content.
        this.$applyButton.store('inner-html', this.$applyButton.innerHTML);
        
        this.$applyButton.on('click', this.applyConfiguration.bindAsEventListener(this));
        this.$cancelButton.on('click', this.cancelConfiguration.bindAsEventListener(this));
        
        this.updateControls();
        
        return this;
    },
    
    show: function () {
        this.$element.removeClassName('hide');
        
        if (Object.isFunction(this.options.onShow)) {
            this.options.onShow.call(this);
        }
    },
    
    hide: function () {
        this.$element.addClassName('hide');
        
        if (Object.isFunction(this.options.onHide)) {
            this.options.onHide.call(this);
        }
    },
    
    updateControls: function () {
        this.$connectorCounter.update(idoit.Translate.get('LC__MODULE__CABLING__VIS__CHANGE_SELECTED_CONNECTORS_TO').replace(':count', this.data.length));
        
        if (this.data.length) {
            this.$applyButton.enable();
        } else {
            this.$applyButton.disable();
        }
    },
    
    applyConfiguration: function () {
        var that            = this,
            connectorTypeId = this.$connectorTypeSelect.getValue(),
            connectorIDs    = this.data
                .pluck('id')
                .map(function (id) {
                    return parseInt(id);
                });
        
        if (!connectorIDs.length) {
            idoit.Notify.info(idoit.Translate.get('LC__MODULE__CABLING__PLEASE_SELECT_AT_LEAST_ONCE_CONNECTOR'), {life: 5});
        }
        
        that.$applyButton.writeAttribute('disabled', 'disabled')
            .down('img').writeAttribute('src', window.dir_images + 'ajax-loading.gif')
            .next('span').update(idoit.Translate.get('LC__UNIVERSAL__LOADING'));
        
        new Ajax.Request(window.www_dir + 'cabling/ajax/updateConnectorTypes', {
            parameters: {
                connectorTypeId: connectorTypeId,
                connectors:      Object.toJSON(connectorIDs)
            },
            onComplete: function (xhr) {
                var json = xhr.responseJSON;
                
                // Not sure why, but ".enable()" does not work properly.
                that.$applyButton.writeAttribute('disabled', null)
                    .update(that.$applyButton.retrieve('inner-html'));
                
                if (json.success) {
                    idoit.Notify.success(idoit.Translate.get('LC__MODULE__CABLING__CONNECTOR_TYPES_CHANGED'), {life: 5});
                    
                    if (Object.isFunction(that.options.onApply)) {
                        that.options.onApply.call(that);
                    }
                } else {
                    idoit.Notify.error(json.message || xhr.responseText, {sticky: true});
                }
            }
        });
    },
    
    cancelConfiguration: function () {
        if (Object.isFunction(this.options.onCancel)) {
            this.options.onCancel.call(this);
        }
    }
});

// [{/literal}] Stop ignoring smarty.
